require( "quest/butterflylist/convout.lua" );
combine_speech_tables();

function spawn_butterfly_icons()
	
	for h,u in pairs(butterfly_numbers) do
			for i,v in pairs(u) do
				if game:Get("captured_butterfly_" .. tostring(v)) == 1 then -- only spawn butterflies that haven't been captured
					scene:Spawn(get_butterfly_icon_spec(v));
				end;
			end;
	end;
--[[
		--make sure its 3 digits long
		
		if game:Get("captured_butterfly_" .. ii) == 1 then
			-- spawn all butterfly icons
			scene:Spawn(get_butterfly_icon_spec(ii));
		end;
	end;
]]
	
	wait_fade();
	
	scene:SetDrawEnvSlideSpeed(0.06);
	
	while not scene:IsDrawEnvSlideDone() do
		delay(1);
	end
	
	scene:Spawn(flo_spec);
	spawn_button(pause_button_help_spec);
	spawn_button(back_button_spec);
	spawn_help_panel();
	
	if game:Get("florida_tutorial") == 2 or game:Get("florida_tutorial") == 6 then
		scene:Spawn(tutorial_dialog_spec);
	end
end

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec)
		coroutine.yield(RESUME.NOW);
		if game:Get("first_time_butterflylist") < 1 then
			game:Set("first_time_butterflylist", 1);
			help_panel_say_raw(scene:grabstring("butterflylist_intro_message"));
		else
			help_panel_say_raw(scene:grabstring("butterflylist_text"));
		end
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function get_butterfly_icon_spec(i)
	--[[if i < 10 then
		ii = "00"..tostring(i);
	elseif i < 100 then
		ii = "0"..tostring(i);
	else
		ii = tostring(i);
	end;]]
		
	return 
	{
		name = "ICON_"..tostring(i);
		gfx = { image = tostring(i) };
		
		command = function(actor)
			actor:SetDepthValue(10);
		end;
	}
end

function go_back(flo)
	flo:SetMode(MODE.CUTSCENE);
	kill_help_panel();
	--scene.PAUSE_BUTTON_HELP:Expire();
	scene:SetDrawEnvSlideSpeed(-0.06);
	
	--raise_hud();
	
	while not scene:IsDrawEnvSlideDone() do
		delay(1);
	end
	
	if game:Get("florida_tutorial") == 2 then
		game:Set("florida_tutorial", 3);
	end
	
	scene:ReturnFromScene();
end;

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	--point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(5);
		actor:SetPointAtCursor("cursor_exit");
		
	end;
		
	on_arrive = function(flo, actor)
		flo:StartProc(go_back);
	end;
	
	on_use_inv = function(item, flo, actor)
		return RESPONSE.INV_HANDLED;
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			--testing data
		end
		
		scene:SetDrawEnvSlidePos(0.0);
		scene:SetCameraFollowActor(nil);
		
		fade_scene_up(true, true);
		scene.PAUSE_BUTTON_HELP:Expire()
		scene.BACK_BUTTON:Expire();
		lower_hud();
		game:ClearInvUsage();
		
		MET_Count("ButterflyScreenVisited");
		
		spawn_butterfly_icons();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces",
	};
	
	bg_image = 
	{
		{ "background", 1 },
	};
	
	ground = "background";
	
	actorlist = 
	{
		scene_setup,
		--back_spec,
	};
};








